package gov.va.med.domain.service.messaging.encode;

import gov.va.med.domain.model.IPayload;
import gov.va.med.domain.service.messaging.MessagingConstants;
import gov.va.med.domain.service.messaging.MessagingException;
import gov.va.med.domain.service.messaging.environment.EndPoint;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MessageEncoder implements MessagingConstants {
    
    private static Logger logger = LogManager.getLogger(MessageEncoder.class);

	public abstract Object encode(IPayload payload, EndPoint ep)
	    throws MessagingException;

	/**
	 * Formats a date using SimpleDateFormat
	 *
	 * @param aDate or null
	 * @return a yyyMMdd string or "" if date is null
	 */
	public static String dateToyyyyMMdd(Date aDate) {
		if(aDate == null) {
			return EMPTY_STRING;
		}
		return new SimpleDateFormat(yyyyMMddFormat).format(aDate);
	}

	/**
	 * Formats a date using SimpleDateFormat
	 *
	 * @param aDate or null
	 * @return a yyyyMMddhhmmss string or "" if date is null
	 */
	public static String dateToyyyyMMddhhmmss(Date aDate) {
		if(aDate == null) {
			return EMPTY_STRING;
		}
		return new SimpleDateFormat(yyyyMMddHHmmssFormat).format(aDate);
	}
	
    protected Logger getLogger() {
        return logger;
    }
}
